//=============================================================================
// ConvergenceAmplify.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2024/12/06 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 収束攻撃機構プラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 指定のメタタグをメモ欄に記載することで
 * その要素を持つアクター/エネミーが、全体対象の攻撃スキルを単体対象に使用する場合
 * 威力を増幅させる機能を搭載するプラグインです。
 * 
 * アクター、エネミー、スキル、職業、装備、ステートのメモ欄に
 * <ConvergenceAmplify:xxx>と記載することで、その要素を持つアクター/エネミーが
 * 体対象の攻撃スキルを単体対象に使用する際に、その威力をxx%増幅させます。
 * 
 * 【設定例】
 * <ConvergenceAmplify:200> とメモ欄に記載された全体攻撃スキルで単体対象に攻撃する場合 
 * そのダメージは200%上昇します。
 * 
 * <ConvergenceAmplify>メタタグは、メモ帳ひとつにつき1つの記載しか有効になりません
 * 複数の装備やステートなどに記載された分は、全て加味されます
 * また、対象が「敵全体」ではない攻撃を行った場合は、特に影響を及ぼしません。
 *
 * 「対象が単体かどうか」の判断は、攻撃を実行する直前の状態で判断されます。
 * 
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

/* 収束倍率値取得 */
Game_BattlerBase.prototype.calcConvergenceAmplify = function(target,value,item) {

    //console.log("beforVal");
    //console.log(value);
    
    var amplify;
    
    if (item && item.meta && item.meta.ConvergenceAmplify) {
        amplify = item.meta.ConvergenceAmplify;
        value = value * amplify / 100;
    }
    
    const states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.ConvergenceAmplify){
            amplify  = states[i].meta.ConvergenceAmplify;
            value = value * amplify / 100;
        }
    }

    if(this.isActor()){
        if (this.actor() && this.actor().meta && this.actor().meta.ConvergenceAmplify) {
            amplify = this.actor().meta.ConvergenceAmplify;
            value = value * amplify / 100;
        }

        if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.ConvergenceAmplify)  {
            amplify = this.currentClass().meta.ConvergenceAmplify;
            value = value * amplify / 100;
        }
        
        const equips = this.equips();
        for (let i = 0; i < equips.length; i++) {      
            if (equips[i] && equips[i].meta && equips[i].meta.ConvergenceAmplify){
                amplify = equips[i].meta.ConvergenceAmplify;
                value = value * amplify / 100;
            }
        }
    }
    else{
        if (this.enemy() && this.enemy().meta && this.enemy().meta.ConvergenceAmplify) {
            amplify  = this.enemy().meta.ConvergenceAmplify;
            value = value * amplify / 100;
        }
    }

    //console.log("afterVal");
    //console.log(value);
    
    return value;
};


/* ダメージ計算関数の末尾で収束出力を加味 */
const _Game_Action_makeDamageValue_ConvDamAply = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical){
    var value = _Game_Action_makeDamageValue_ConvDamAply.apply(this, arguments);
    if(this.isSingleTarget()){
        //console.log("ConvergenceAmplify Invoke!");
        value = this.subject().calcConvergenceAmplify(target,value,this.item());
    }
    return Math.round(value);
};

Game_Action.prototype.isSingleTarget = function() {
    if(this.item().scope != 2){
        return false;
    }
    //console.log(BattleManager.getTargetNum());
    var targetsNum = BattleManager.getTargetNum();
    return targetsNum == 1 ? true : false;
};

BattleManager.getTargetNum = function() {
    return this.targetsNum;
};

const _BattleManager_startAction = BattleManager.startAction;
BattleManager.startAction = function() {
    _BattleManager_startAction.apply(this, arguments);
    this.targetsNum = 0;
    if(this._targets){
        this.targetsNum = this._targets.length;
    }
};

const _BattleManager_endAction = BattleManager.endAction;
BattleManager.endAction = function() {
    _BattleManager_endAction.apply(this, arguments);
    this.targetsNum = 0;
};

})();